<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Place extends Model 
{

    protected $table = 'places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'user_id', 'city_id', 'longitude', 'latitude');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function city()
    {
        return $this->hasOne('App\Models\City');
    }

    public function country()
    {
        return $this->hasOne('App\Models\Country');
    }

}